import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Customer\CallLogsController::index
 * @see app/Http/Controllers/Customer/CallLogsController.php:12
 * @route '/my-calls'
 */
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/my-calls',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Customer\CallLogsController::index
 * @see app/Http/Controllers/Customer/CallLogsController.php:12
 * @route '/my-calls'
 */
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Customer\CallLogsController::index
 * @see app/Http/Controllers/Customer/CallLogsController.php:12
 * @route '/my-calls'
 */
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\Customer\CallLogsController::index
 * @see app/Http/Controllers/Customer/CallLogsController.php:12
 * @route '/my-calls'
 */
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\Customer\CallLogsController::index
 * @see app/Http/Controllers/Customer/CallLogsController.php:12
 * @route '/my-calls'
 */
    const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: index.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\Customer\CallLogsController::index
 * @see app/Http/Controllers/Customer/CallLogsController.php:12
 * @route '/my-calls'
 */
        indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\Customer\CallLogsController::index
 * @see app/Http/Controllers/Customer/CallLogsController.php:12
 * @route '/my-calls'
 */
        indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    index.form = indexForm
const CallLogsController = { index }

export default CallLogsController