<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Ip_messaging
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\IpMessaging\V2\Service\User;

use Twilio\Exceptions\TwilioException;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;
use Twilio\Serialize;


class UserChannelContext extends InstanceContext
    {
    /**
     * Initialize the UserChannelContext
     *
     * @param Version $version Version that contains the resource
     * @param string $serviceSid 
     * @param string $userSid 
     * @param string $channelSid 
     */
    public function __construct(
        Version $version,
        $serviceSid,
        $userSid,
        $channelSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'serviceSid' =>
            $serviceSid,
        'userSid' =>
            $userSid,
        'channelSid' =>
            $channelSid,
        ];

        $this->uri = '/Services/' . \rawurlencode($serviceSid)
        .'/Users/' . \rawurlencode($userSid)
        .'/Channels/' . \rawurlencode($channelSid)
        .'';
    }

    /**
     * Helper function for Delete
     *
     * @return Response Deleted Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _delete(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded' ]);
        return $this->version->handleRequest('DELETE', $this->uri, [], [], $headers, "delete");
    }

    /**
     * Delete the UserChannelInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool
    {
        $response = $this->_delete();
        
        return true;
    }

    /**
     * Delete the UserChannelInstance with Metadata
     *
     * @return ResourceMetadata The Deleted Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function deleteWithMetadata(): ResourceMetadata
    {
        $response = $this->_delete();
        
        return new ResourceMetadata(
            null,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Fetch
     *
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, [], [], $headers, "fetch");
    }

    /**
     * Fetch the UserChannelInstance
     *
     * @return UserChannelInstance Fetched UserChannelInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): UserChannelInstance
    {
        $response = $this->_fetch();
        return new UserChannelInstance(
            $this->version,
            $response->getContent(),
            $this->solution['serviceSid'],
            $this->solution['userSid'],
            $this->solution['channelSid']
        );
        
    }

    /**
     * Fetch the UserChannelInstance with Metadata
     *
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(): ResourceMetadata
    {
        $response = $this->_fetch();
        $resource = new UserChannelInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['serviceSid'],
                        $this->solution['userSid'],
                        $this->solution['channelSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Update
     *
     * @param array|Options $options Optional Arguments
     * @return Response Updated Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _update(array $options = []): Response
    {
        $options = new Values($options);

        $data = Values::of([
            'NotificationLevel' =>
                $options['notificationLevel'],
            'LastConsumedMessageIndex' =>
                $options['lastConsumedMessageIndex'],
            'LastConsumptionTimestamp' =>
                Serialize::iso8601DateTime($options['lastConsumptionTimestamp']),
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "update");
    }

    /**
     * Update the UserChannelInstance
     *
     * @param array|Options $options Optional Arguments
     * @return UserChannelInstance Updated UserChannelInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(array $options = []): UserChannelInstance
    {
        $response = $this->_update($options);
        return new UserChannelInstance(
            $this->version,
            $response->getContent(),
            $this->solution['serviceSid'],
            $this->solution['userSid'],
            $this->solution['channelSid']
        );
        
    }

    /**
     * Update the UserChannelInstance with Metadata
     *
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Updated Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function updateWithMetadata(array $options = []): ResourceMetadata
    {
        $response = $this->_update($options);
        $resource = new UserChannelInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['serviceSid'],
                        $this->solution['userSid'],
                        $this->solution['channelSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.IpMessaging.V2.UserChannelContext ' . \implode(' ', $context) . ']';
    }
}
