<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Organization Public API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\PreviewIam\Versionless\Organization;

use Twilio\Exceptions\TwilioException;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class AccountContext extends InstanceContext
    {
    /**
     * Initialize the AccountContext
     *
     * @param Version $version Version that contains the resource
     * @param string $organizationSid
     * @param string $accountSid
     */
    public function __construct(
        Version $version,
        $organizationSid,
        $accountSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'organizationSid' =>
            $organizationSid,
        'accountSid' =>
            $accountSid,
        ];

        $this->uri = '/' . \rawurlencode($organizationSid)
        .'/Accounts/' . \rawurlencode($accountSid)
        .'';
    }

    /**
     * Helper function for Fetch
     *
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, [], [], $headers, "fetch");
    }

    /**
     * Fetch the AccountInstance
     *
     * @return AccountInstance Fetched AccountInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): AccountInstance
    {
        $response = $this->_fetch();
        return new AccountInstance(
            $this->version,
            $response->getContent(),
            $this->solution['organizationSid'],
            $this->solution['accountSid']
        );
        
    }

    /**
     * Fetch the AccountInstance with Metadata
     *
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(): ResourceMetadata
    {
        $response = $this->_fetch();
        $resource = new AccountInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['organizationSid'],
                        $this->solution['accountSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.PreviewIam.Versionless.AccountContext ' . \implode(' ', $context) . ']';
    }
}
